import { View, Text, StyleSheet } from "react-native";
import React from "react";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
import { ratingAndReviewsStyle } from "../RatingAndReviewsStyle";
import ProgressiveImage from "../../../../../../src/components/ProgressiveImage";
import usePreferences from "../../../../../../hooks/usePreferences";
import { MaterialIcons } from "@expo/vector-icons";
import CustomRating from "../../../../../Utilities/CustomRating/CustomRating";
import { round } from "../../../../../../helper/ratingRound";
import SingleReviewImages from "./SingleReviewImages";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";

const SingleReview = ({ item, index, Reviews }) => {
    const {trans} = useLangTranslation()
    const {
        product_general: { reviews_verified_owner_label, rating_enable } = {},
    } = usePreferences();

    return (
        <View style={Styles({ index, Reviews }).cont}>
            <View style={ratingAndReviewsStyle.userCont}>
                <View style={ratingAndReviewsStyle.userSubCont}>
                    <ProgressiveImage
                        source={{
                            uri: item.user_image,
                        }}
                        style={ratingAndReviewsStyle.userImg}
                    />
                    <View>
                        <Text style={ratingAndReviewsStyle.userName}>
                            {item.user_name}
                        </Text>
                        <Text style={ratingAndReviewsStyle.time}>
                            {item?.created_at}
                        </Text>

                        {(reviews_verified_owner_label == "0" ||
                            item?.verified_purchase) && (
                            <View style={ratingAndReviewsStyle.userVerify}>
                                <MaterialIcons
                                    name='verified-user'
                                    size={dpr(16)}
                                    color='#FCCA19'
                                />
                                <Text
                                    style={ratingAndReviewsStyle.userVerifyText}
                                >
                                    {trans("Verified Purchase")}
                                </Text>
                            </View>
                        )}
                    </View>
                </View>
                {rating_enable == 1 && (
                    <CustomRating
                        rating={round(item?.rating)}
                        starSize={dpr(18)}
                        readOnly={true}
                    />
                )}
            </View>
            <Text style={ratingAndReviewsStyle.text}>{item?.comments}</Text>
            <SingleReviewImages images={item?.image} />
        </View>
    );
};

export default SingleReview;

const Styles = (props) => StyleSheet.create({
    cont: {
        paddingBottom: props.index + 1 === props.Reviews?.length ? 0 : dpr(20),
        borderBottomWidth: props.index + 1 === props.Reviews?.length ? 0 : 1,
        borderBottomColor: "#DFDFDF",
    },
});